<?php
/*--------------------------------------------------------------
   GambioCategoriesRankingOverview.php 2021-08-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities\WidgetDefinition;

use Doctrine\DBAL\Connection;
use Gambio\Admin\Modules\Statistics\App\Data\Factory as DataFactory;
use Gambio\Admin\Modules\Statistics\App\Overview\Factory as OverviewFactory;
use Gambio\Admin\Modules\Statistics\App\Overview\Factory\Option\Predefined\MaxEntriesDropdown;
use Gambio\Admin\Modules\Statistics\App\Overview\Factory\Option\Predefined\TimespanDropdown;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\Options;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;
use Gambio\Core\Application\ValueObjects\UserPreferences;

class GambioCategoriesRankingOverview extends GambioWidgetDefinition
{
    private const TYPE = 'gambio.categories.ranking.overview';
    
    private const VERSION = '0.1.0';
    
    private const ICON = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAQQAAACoCAYAAAAGoZArAAAACXBIWXMAAC4jAAAuIwF4pT92AAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAGsdJREFUeJzt3Xt0E2X6B/DvO5nJrUmblrZQoCh3Wy1YQERYEVBBUFBBQARW5CqLK3LxtoCyLKviyooiurCiouD+QCmColK1AgqugKBcWmkKAQIESKUpbZN0Zpr39wewK25baJtkkvb5nNPDOUyaeZqm37y3eQcghBBCCCGEEEIIIYQQQgghhBBCCCGEEEIIIYQQQgghhBBCCCGEEEIIIYQQQgghhBBCCCGEEEIIIYQQQgghhBBCCCGEEEIIIYQQAqZ1AUQbnHMBwMUv/YX/LgfAGWOqZoURTYlaF0BCh3NuABADwCLLstnrVU0GA9NLkqRHNR8GnHMA4ABkRVHKJUnyAvADKANQwhiTw1A+0QC1EOoRzrkZQHyZLCcIFRWxJpNJV1RSEvghNx8Hfj4kOI+74HS5cdx1Ci5PEVRVRUmJH4tmT8WQAX2we/c+iNL5zwhJFGE0GmE0ijCKRlgsxoDVaoUoigIARZblEr1e7wFwljHm1fLnJsFDLYQoxzmPKy9HckCnJqqqKh3IPxz45OvvhO179mBPnh0ut1u43HP4VfXCvwqgKv89UFLy64cJAGAUJcTHWySLxZKQaLPZrFZrK1mWZUmS3AB+AVDMGONB/BFJGFEgRCHOuQlAis/na6yqqvjpN9/ylR99LuRs3wNPadFlA6Au/KoCl7sIcBfBDqdwPiBs+iaJiSnx8damoiiqnPNTAFyMMX8oayHBR4EQRTjn8bIsN1dVNX7zDz8F3v7gE2FD9laU+ks06/qdDwg3XG63IAJISUmSmiQmNo+Pj08tLy/36PV6J2OsSKv6SM1QIEQBznkjr9fbyq+qxrezPsPLb78Pu8MR0pZAbagAnC43nC43s5hMSGmSaGuZmhrHOS8DcIQxdlbrGkn1KBAiGOfc5lWUVn6/P+Zv//wXW7RiDTyl0fFhW+rzwe5wwuk8xVJTm1hapqZeK8uyV5KkQ4wxj9b1kcpRIEQgzrlBluW2qqrGv/HuB2zB0hVwe6IjCH7Lryq/DoaYlqmpGZzzQgCHaPoy8lAgRBDOOQPQVFXVll9/t5NNfuZF5nC5tC4rKC4Gg+tUIWvb5urEpPj4RpxzB4CTNCsROSgQIgTn3OhVlPRyv9/88JwFwppPs7UuKSRKfT7s2ZfHUpKSWFrbli1FUUzmnOfRjERkoECIAJzzJL+qtv80Zyub8PSLLFrGCerC5XbDXeQR0tpebUlJSurCOT/IGHNrXVdDR4GgIc65UF6ONqqqNn5k9gK2PGu91iWFlaoq2JdnZx6Ph6W1bXuN3++PNxgMBYyxgNa1NVQUCBrhnEteRbnu1OnCmLsmPMbyHA6tS9KM0+VGkaeUdcpISwZg5pzvpwustBFxc9kNAefcpChKZl6uPabbfWOEhhwGF5X6fNixe59QVFRkVRR0vrAak4QZBUKYcc4tPlXttPrTHEO3EZOFaJ1ODAW/qmDPvjxW6HHrAWRyzq1a19TQUCCEEefcqqpqx1eXr9KNfnwOU1Wf1iVFHBXAvjw7czidIoAOnHOL1jU1JBQIYcI5t6iq2uGVFWt0Ty1conU5Ec/ucMLhcOoAdKRQCB8KhDDgnJtVVe24cPkq3cwFi7QuJ2rYnU44XS4B51sKZq3raQgoEEKMcy75fErGyo82CdQyqLk8u4O5XG4dzoeCpHU99R0FQghxzgWvV8nYsS9PP+GZF2l3qlrKs9tZUVGJCOC6C3tBkhChFzeEZFluf6rQZb7n4Wk0gFgH5wcafxb8qhojy3I7reupzygQQoRz3iQQEBLvmPC44Cktufw3kGr5VQW79+wTBEFI4pynaF1PfUWBEAIXBhHbjpv9V2anRUdBU+rzIc/uYABa08Kl0KBACDLOOfMqyrUrP9qE9zds1LqceufCdm0MQPqFy8VJEFEgBF+LYo/HMHkeDSKGSp79CFNV1QQgVeta6hsKhCDinJtUVW0x/ukFgt9Pg4ihcuEqSQHAVdR1CC4KhCAqU5T2H276Cp9u3ap1KfWeu6gILrcbsiy31bqW+oQCIUg454m6igrro39+lboKYWI/coTp9fo4znmC1rXUFxQIQcA5Zz6fr9X8pSuY20Ob/oSL36fA4XAyAG1ogDE4KBCCo7HfrxpeWb5G6zoaHIfLCVVV9QAaa11LfUCBUEecc6YoytV/fn0ZK/XTAqRwU1XA4XQKAFpoXUt9QIFQd4mlpX5p6aoNWtfRYDldhVBV1cA5T9S6lmhHgVBHXq839dV31zA/XaugGVVV4HS6GICrtK4l2lEg1AHnPEGv11uWrsnSupQGz+k6BZzfoDVW61qiGQVCHSiK0goAXnpyCnpmdtK6nAbNrypwu90ADS7WCQVCLXHOBcaY8V8bs8u7XZ8Z+GrVazi2ZT2enPQgUmxJWpfXIJ0qLGQAkmnPhNqjF672En0+Hx/3xPP+1r3uPZc+4IFz+w8elmdNHMdP7tiIr1YtxbC+fSGCNvkJF7e7CKqqMgC0UKmW6EYttSTLcvKH2TmqoigcAOwFxwIDxs7wAsC0ccP1U0YPN6xYNFf3WulMvLV6PZa+vwEOl1PbokNEEAShZYumba0WS3NJFONFposP9jlkVT75w768ai8fVQE4XS6hWePGTQAUBruGhoACoRYuNElt67K3eSs7/vLy1fLLy1fLyUk29tITjxrHDhukf3LSg2zrzj1YsmItsnK+QX3YQSm1WeOmV6U0vd9oNHQXBCHoIXCpGHTL7Jj87z0/vV3dozyeUrRMTbVxzhndVbrmqMtQOza/34/PN39XUd2Dzrg9/PePz/Mld+5fPHLqM2WxsbEVKxbNRdHuTfjH/NnIaBud1+VYYmKMv+uS+ce01q3fNptNd4Y+DM6LtcaM6pbZ8aHqHlNUVAQADADd5KUWKBBqJ/7bH376T3fhSrz/cbaS2X9kSUrXu4rXbcwpH9z7Zr534yrsXb8Kk4YNgcUYHe/fxslJiTd0uPZls9l0DzRoYcZaY0Z175w5sarjKoCiohIOICwhVd9QINSCV1FsW3ftrbZ1UBWP50Kr4cb+xbeOfqS0xO9XXpo9Fe4dG/Hm/NnITEsPdrlB0zghvtF17Vq/LkmiphudWmJMw7tldhxb2bF4qxWMVQiKotC+i7VAYwg1xDnXATB/+e/vS+v6XDnbdqk523apklliC6ZNNowa1F8/btggwe5wYnnWBixdtQGe0si496PBoDekX9N2nk4QGmldCwDEWmNG9uicKR4+dnxZk0QbTCYTRFGE0WiE2+MBY0xP4wg1R5eM1hDnPM7v93cwXd+rGHLwn/+mTtfpXnjyEVOnjGtEoyhiQ/ZWLF2TheztewAowT8hgH/Mn42Rg/pi+47dVT6mW2bHh2KtMaOqe56SMi/25x9ipWXBGTBlDOjVrTMXdbrqHvaBp6xs5wmXG2cKC+E6XYhSXznGDxsIQRAOAiivQwnlAE4BOMkYq3QAub6hFkLNxRw5fVoNRRgAwHe791fcMvzhUgB4ZNxw/WOjhxs29l2kc7ndWPJ+Ft5a/SnCvedCclJ8gtVivq+q4wVHj7OnXlwifJzzLZOV4IbWfXf04f965S8VlYUC5wDAh8aZzUPjWl+F9Nb/vZSBMQYAwWodVHDOvwfwCYD3GGOng/S8EYfGEGou5sDBw4FwnOi15avlNr0Gl1w/4MFzB/Idyqwp4/jJ7eux8c1FYV301LJ584GMMWNlxzZ/v5t1uWeMbu2mr4MeBgDw4ec57P5HZ+uUigpwzi/5uoK/92C1gHUAugN4DkAe53xOfb3XJAVCDZWVlcXYC06GJRAuOlBwKND/oellsem9ip9YsNh7zdXNA6sWzcXJHRvxwowpaJkS2vEzs8nUvbL/P3mmEEOmPKUrLqnzcEq11m76mt3/x1k6RVVDep4rZAEwB8A3nPOrNa4l6CgQakiv1xvsJ49oNlD18vLVcutew84163FX8edfbS8fO3gQP7xlPbaEaKl0QrwtXhLF1pUde+71d4SznnNBPV9VsrI3sxFT51xxKIThF5QBYBvn/JrQnyp8KBBqgHPOJEnSHznqCmsLoTL/WfR0Y//iMTP/UtbowqIn945NWDRrZtAWPcXHWZJRRdN77aavw/r+ycrezO6fOvvKQoGHJbOTAKyrT5u80qBizYgAmPP4Gc0D4ddWZG1UVmRtVGw2G3v12UeNDwy6XT/1wWFsX54dS1ZlYcWGT1Hb+0SY9KZK3+wlZV6ccv9Sp7prY132Fnb/1Nm6ZX99ukJg1efRhYHFWrNazLjMDAcAtAawBMCIOp0sQlAg1IwIACeLCyNybtvj8fDfT5vnA+Dr06OL+JfpkwwvzZ4qLZo9Fas2ZGPJqizsycut0XOKoq7SG6GUlmk3C7cuewtbl70l5O9dQRDQIqUxv/v2nvyJiaMDTZMTq/q9D+Gcd2eMbQ91TaFGXYaaEQHwMo83IgPh13K27VJ7DJlQltDl9uI31mT5B/W+ObB7/TvYu3EVpj44EjbLla3sFRrwOyQQCODICRd75Z3VQnq/+8XPtnxXXZPjybAVFkIN+NddKzq/qkZ8GPya4lX49Lmv+pNv7H/ulhGTS4o8Zer8GZPg3rERaxe9gL7du17y+KT4eKS1bYmunTqge6dOSEy4tMdw6bRfw1FcUoohU54Sdx84WFUo3MY5t4W1qBCglYo1wDm3+f3+60zpvcIztB4ier0ef54xyfDgPX0NSfFJAqBCFEWo6vl/8xwO5Hy3B9t37MPowf369Lv5xlm/fQ7XmUI06zGwwXU5e3TuwL9dvayqUc0RjLG1YS0oyBrcL7SOWAjW3oSdLMt4+vnF5YrXi8cnjTYajUbm96u4++GZ2L57H359f4khA27RsNLIs+2HvSzf4WTtWqZW1kSK+ilI6jLUTEAyRX+G9unRRTy6bV3s01MmmFZ+tAlPLXw94Ff9yN6+HXSzmcvbk1tlt6FJWAsJgeh/d4dXhRjFIdospZGwbulCc+Y1bcTde/P53ROeUH88aA/06dZZsBgtgihKUNV60AQKsbOe4qoORf16hKh9c2ukQhRFxJjN0TX2ogfefXmeqeCrtbFN4uLE4dOeqbhx+Fjlx4P2AADszz/MRRHonpGhdaVRoT6Pp1Ig1IwKAE2bJkZNIEwbN1x/bucXcUP79TQsWPZ+oHW/oXLW5zmXbO5y5mwRLy314+aumVqVSSIEdRlqgDGmKIrCUxsnC/aCYxG1WvG3bu7aUVz592dNLZo21X246Sv+2DOLlBNn3VV+th076eKd0tpGTdCR0KBAqCFFUZRWzZuzHOzSupRK2Ww2tvEffzN37ZQm7c7N5/f9Yba680DuZcNrrz0f17ZrFY4SSQSjLkMNBQKiv3VqakS+bkufe9zk2v5RXGpqE2n8n56vuHHIWOVKwgAADh09wRNtUb+uhtQRtRBqKCZGKk1rc1VE7Ct40QOD+0qLZk0zW61Wtvif/8efXbxc8Sk1u5gpz36Ex1ujY+dnEjoUCDXnbd8qNSJu3tgxo71u7eLnza1bNNV9uGkLf2zeS8qJM1WPE1TngN3BjUYjkmzxcHsiY2NXEn4R2fSNcGVXX91MlCRJswE4m83MNq98I2bX2uVWb3mZ7tYRU9ShjzxZ6zAAgIOHHQEA6N39huAVSqIOBULNlRhFETd1uk6T127BE38wOrduiEtPbylNmbsw0GHAaDln1w91nvHwKSpcbje6Z0TufSFI6FEg1BBjLKAoiveWLhlh7W49MLCvdOaHz+Kmj3/A+O66zwJtbhkqL1u9LqibDB52unhGWnTeXo4EBwVCLQQCAU+f33W77FY6wXBtm9bC/i9WWVcsnBezY28u0u54QJkyb6F6zhv8aw725juQmhL1y/FJHVAg1ILBYDj7u84dQjqOoNfr8X9L5pt3fboiVggIujsfmqreNX6GUnD0WMgWzh46dJTb4mmmoSGjQKidYgDsjl5dQtJKeH7mw4biH7Pj+t3UTf/UglcC6QNGyNn//j7kKyNzHQ4eb7GE+jQkglEg1AJjLBAIBIqGDrg9qHueD+x1k3h028exMyeOMa38aBNa33qv/Mo7H4TtZgT2gqMBURSj9jb1pO4oEGpJr9efvqdP76B0G5qlNBJ2bHjHkrXsZYvD6WQZdwxTJsx5Xjl7Lrx7ExScOMn9qoqeXTuF9bwkclAg1N5Zq9XEBva6qdbdBr1ej7VLXjAXbFkfmxgXJw754xMVvUb+Qfk5hOMEl+N0unBDRppWpycao0CoJcZYBQD3pNHDa9VtmPHQCMOpnRvj+vbupp/7yrJA+z73yhu+3Fpx+e8MrfzDh3l625Zal0E0QkuX68bV93edk5ulNCo/4frligb9bu7RUVz54lxzi5QUYeX6TXzGc4uUM2eLImbLjVyHEx3S22ldBtEItRDqgDF2zqsovhljR+ov99hmiY2E7VlvWnLeXmI55SpimfeMVkfPfDaiwgAAfi44Shc5NWAUCHVklqRj40cO1ttsVW+r9sb8p4wFW9fGNm/cSBx5cfuyA/aI3GCl4OjRgMVigVGs9IZNpJ6jQKg7t1GnU6Y/OOJ/WgmPjBuuP/fTF3FjBt9hXPDW+4H2tw6V1/xm+7JI82Pu+YucetJ2ag0SBUIdMca4JElHHxs76j+thC6drtMVbM6yLp41zbxp+w60uXWoMvflZapPCduSglo75y2Bx1OK7jfQhqsNEQ0qBsdpo1FMfX7mo4YOba7Sde2UIe3NzeddH72y7csizeGTJ3km7a/YIFEgBAFjjHPOj40fdld7d1ERxjw+r2LVJ9kR3TWoTq7dgc4009AgUZchSBhjpznn3p0/7o/qMADOzzQk2q7s7tCkfqFACCJJkvYPuL03u7tvr6h+Xe1HjnCr1ah1GUQDUf3GjTSMMb/q9x97Y+4MIdYcvdN2ufnn91dMTYqIrSNJGFEgBJnRaHQm2mz+1//yp7BsoBIKB53OgKqq6HNTV61LIWFGgRBkF6YhDwwf0JtNGDIwKl9f5cL+ijd0oqnHhiYq37CRjjHmE0XR/urcGbqMNq2icvou3+niGXSRU4NDgRAijLHTgiC4P1n+kpAQG33XBuTmH0ZqkyZQVbXS1VSS1HBnrKv52ZVw1hEKFAghpNfr81OSkrybli/SRdsf0KFD5y9yOn7qdKV3bUmIi4XJaAh3WREhNSW5qgvSXGEtJAQoEEKIMRaQJGn/te1bqW+/8GxUDTLmOo5wi8WI3ENHf6nsuCAI6HNTl4i6UjMczCYjbr7hegoEUjuMMcVkMu0dPKA3Fs+eHjWhkGs/EhBFEbn2Iy5/uVxpKDw+fmSAsagcIqm1R0bfF4gxVTml/F04awkFCoQwYIz5TKL407iRg/HG3CeiIhROnHFzv9+P7p2v5c5Tpyp9o/fsmsln/WFM1F2rUVvdrr+O/3nqxKpWoboA7ApnPaFAgRAmjLFSkyj+NH74oKhpKRx2uXjXjDRkbfp6U1WPmffYxMBrz84MxFnr7/btgiBgzJA7A1++t1g1GqrcC+ddxljUd6EaVnsvAnDOLaqqdsj64hs2asacCiWCL4n+4LW/Sq1btGCd7h6J499snNc0ObFHVY8tKi7Bhq+2sh/z7Mzr84ezzJCRRBEtU5vyQbf25O1aplb3x14III0xVhyu2kKFAkEDnHOjT1E6HMw/LN0xblrF6V/Oal1SpV6YNkX8/b13CE1vuROTRgxutnjOzH+IOp05lOf81ZhENH3aTmSMvaN1EcFAXQYNMMb8JknafW27VmU71i0XM69pH5HBnHfkCLdeuLXb0n9lnVjx0SfzOOchGzOI0jB4vb6EAUCBoBnGmCpJ0k+NE1JO71i3XHx01LCI+13k5ju4xWiExXg+FCb86bmdH3/9zQuBAJeDeR7GWLSGwXIAM7UuIpgi7k3YkDDGuNHI7KIo5i2c9Shbv+xvukha1bjfcX5/xT7d/7u/4j2TH//qxX+umO7zl58Jxjl+EwTREgY+ANMYY5MZY5E7CFQLFAgRgDFWKIriD7fd2NlXsDlLHDWof0T8XnxeH9xuD7pnXnprtz/9/Y28tAH3P7h9z96liqrWbiAtOlsFMoAVANIZY0u0LiYUIrLv2pBxzpuqqtrqm10/8omznwsUHD2p6R/L92vfkjweD+s3/rFKj9tiY3V/nT65w82dO3ZtFB+XajIaGxkkqcpmjiAw6CUJgiAA59f+R/InrA/AcQAnAHwJILs+zCRUhwIhAnHODbIstxEEfcKbq7MCcxe/qdlMxD+fnyPd0rkDa9dvSJ2eJyUpCfOmTeRj7rmT+QOBXyx6/SHGWP2Yn6xHIqJpSi7FGCs3GAwHRBF7xw0b6D2yOUt6bsZkXUJsQthrKTh0lNviaz+ukZKUhPlTJ+HwlvV8RP/bSkRR3G01GA5QGEQmaiFEAc55gldRWukZM63a8EVg4dvvBfb9fDgsXYlBt/XUrV78nM6U3r1G33dDRgdMHzuU339nP3i9itdslhyMschccEH+gwIhinDObbIsNxcEIWHXjwcr3vroE7764y8D57wlITvnNVe1YHlfrpHa3ToEdqez2sdajFYM6tsT08eOCHROb8dKZfkXi15/nDF2LmQFkqCiQIhCnHMjgBSfojSWGJNytu+seG99Nr7Y9n0gFGMNSt63+kfmLsTSNWv/51hKUhIG9e6J+wbeFuh1Y2em+FTVZBJdAE4yxoK6XoGEHgVClOOcxwJI9vl8SSaTSTp46FjFZ5v/jc3f7+a7DhzgJ86469y1OJzzgT7nuz0YP3s+2qamIjMjDV0z0tHrpi6BzuntBJ/P5zeZTGcA/MIYC11zhYQcBUI9wjk3A7DJspxQIQixJlEUS0pKAvsPHQ38dCCfHTt5Bs5Tp7nT5eani85AVVScLSrhF3dJE0URCfFWJkJE4+RkpKYksdQmjdnkUXfr4q1WcM651WplPp+vvEKnK7Ho9cUAzjLGfJr+4CRoKBDqMc65HoAFgEWWZbOiKEZBr9ebJEmPy88wBXw+RQ4E5PKYmBgOoBzAaQAljLGovjMVqRoFQgPFOWcAdDgfDBfDIXDxizHWYDY+IYQQQgghhBBCCCGEEEIIIYQQQgghhBBCCCGEEEIIIYQQQgghhBBCCCGEEEIIIYQQQgghhBBCCCGEEEIIIYQQQgghhBBCCCGEEEIu8f9ls3kP/p3fpwAAAABJRU5ErkJggg==";
    
    private const WIDGET_TITLE = [
        self::LANGUAGE_CODE_GERMAN  => 'Meistverkaufte Kategorien',
        self::LANGUAGE_CODE_ENGLISH => 'Best-selling categories'
    ];
    
    /**
     * @var DataFactory
     */
    private $dataFactory;
    
    /**
     * @var UserPreferences
     */
    private $userPreferences;
    
    /**
     * @var Connection
     */
    private $connection;
    
    
    /**
     * @inheritDoc
     */
    public function __construct(
        OverviewFactory $overviewFactory,
        DataFactory $dataFactory,
        UserPreferences $userPreferences,
        Connection $connection
    ) {
        $this->dataFactory     = $dataFactory;
        $this->userPreferences = $userPreferences;
        $this->connection      = $connection;
        
        parent::__construct($overviewFactory->createType(self::TYPE),
                            $overviewFactory->createVersion(self::VERSION),
                            $overviewFactory->createIconUsingData(self::ICON),
                            $overviewFactory->useVisualizations()->createPieChart(),
                            $overviewFactory->useOptions()->createOptions($overviewFactory->useOptions()
                                                                              ->usePredefined()
                                                                              ->createTimespanDropdown($overviewFactory),
                                                                          $overviewFactory->useOptions()
                                                                              ->usePredefined()
                                                                              ->createMaxEntriesDropdown($overviewFactory)),
                            $overviewFactory->createTitles($overviewFactory->createTitle($overviewFactory->createLanguageCode(self::LANGUAGE_CODE_GERMAN),
                                                                                         self::WIDGET_TITLE[self::LANGUAGE_CODE_GERMAN]),
                                                           $overviewFactory->createTitle($overviewFactory->createLanguageCode(self::LANGUAGE_CODE_ENGLISH),
                                                                                         self::WIDGET_TITLE[self::LANGUAGE_CODE_ENGLISH])));
    }
    
    
    /**
     * @inheritDoc
     */
    public function data(Options $options): Data
    {
        $timespan   = $this->dataFactory->useTimespan()->createFromTerm($options->getById(TimespanDropdown::ID)
                                                                            ->value());
        $categories = $this->connection->createQueryBuilder()
            ->select([
                         'COUNT(categories_description.categories_name) AS orders',
                         'categories_description.categories_name AS name'
                     ])
            ->from('orders_products')
            ->join('orders_products',
                   'products_to_categories',
                   'products_to_categories',
                   'orders_products.products_id = products_to_categories.products_id')
            ->join('products_to_categories',
                   'categories_description',
                   'categories_description',
                   'products_to_categories.categories_id = categories_description.categories_id')
            ->join('orders_products', 'orders', 'orders', 'orders_products.orders_id = orders.orders_id')
            ->where('categories_description.language_id = :languageId')
            ->andWhere('orders_status NOT IN (:excludedOrderIds)')
            ->andWhere('date_purchased BETWEEN :startDate AND :endDate')
            ->groupBy('name')
            ->orderBy('orders', 'DESC')
            ->addOrderBy('name')
            ->setParameters([
                                ':excludedOrderIds' => implode(',', self::EXCLUDED_ORDER_STATUS_IDS),
                                ':languageId'       => $this->userPreferences->languageId(),
                                ':startDate'        => $timespan->startDate()
                                    ->format(self::QUERY_TIMESPAN_FORMAT_DATE_START),
                                ':endDate'          => $timespan->endDate()
                                    ->format(self::QUERY_TIMESPAN_FORMAT_DATE_END)
                            ])
            ->setMaxResults((int)$options->getById(MaxEntriesDropdown::ID)->value())
            ->execute()
            ->fetchAll();
        
        return $this->dataFactory->useMapData()->createMapData($this->dataFactory->useMapData()
                                                                   ->createItems(...array_map(function ($rankingItem) {
                                                                       return $this->dataFactory->useMapData()
                                                                           ->createItem($this->dataFactory->useMapData()
                                                                                            ->createItemTitle($rankingItem['name']),
                                                                                        $this->dataFactory->useMapData()
                                                                                            ->createItemValue((int)$rankingItem['orders']));
                                                                   },
                                                                       $categories)));
    }
}
